using System;
using Server;
using Server.Items;
using Server.Mobiles;

namespace Server.Items
{
	public class Stit : BaseShield
	{
		public override int ArtifactRarity{ get{ return 100; } }
		
		public override int BasePhysicalResistance{ get{ return 15; } }
		public override int BaseFireResistance{ get{ return 10; } }
		public override int BaseColdResistance{ get{ return 10; } }
		public override int BasePoisonResistance{ get{ return 10; } }
		public override int BaseEnergyResistance{ get{ return 10; } }

		public override int InitMinHits{ get{ return 125; } }
		public override int InitMaxHits{ get{ return 125; } }

		public override int AosStrReq{ get{ return 45; } }

		public override int ArmorBase{ get{ return 11; } }
		
		private DateTime m_NextSpecial;

		[Constructable]
		public Stit() : base( 0x1B7B )
		{
			Weight = 6.0;
			Name = "Stit";
			Hue = 1195;
			LootType = LootType.Blessed;
			ArmorAttributes.DurabilityBonus = 30;
			ArmorAttributes.MageArmor = 1;
			ArmorAttributes.SelfRepair = 5;
			Attributes.BonusDex = 5;
			Attributes.BonusHits = 20;
			Attributes.BonusStam = 25;
			Attributes.BonusStr = 10;
			Attributes.CastRecovery = 2;
			Attributes.CastSpeed = 2;
			Attributes.DefendChance = 35;
			Attributes.Luck = 200;
			Attributes.RegenHits = 2;
			Attributes.RegenStam = 2;
         Attributes.SpellChanneling = 1;
			
			SkillBonuses.SetValues( 0, SkillName.Parry, 20.0 );
		}
		
		public override int OnHit( BaseWeapon weapon, int damage )
		{
			if ( DateTime.Now > m_NextSpecial )
			{
				PlayerMobile parent = this.Parent as PlayerMobile;
				if( parent != null && parent.Map != null )
				{
					m_NextSpecial = DateTime.Now + TimeSpan.FromSeconds( 10.0 );
					Effects.PlaySound( parent.Location, parent.Map, 0x207 );
					
					ZoogiVejce.EffectCircle( parent.Location, parent.Map, 3, 0x376A );
					
					foreach ( Mobile mobile in parent.Map.GetMobilesInRange( parent.Location, 2 ) )
					{
						if ( mobile != null && mobile is BaseCreature && parent.InLOS( mobile ) )
						{
							BaseCreature mon = (BaseCreature) mobile;
							
							mon.Pacify( parent, DateTime.Now + TimeSpan.FromSeconds( 6.0 ) ); // TODO check
						}
					}
				}
			}
			
			return base.OnHit( weapon, damage );
		}
		
		public override void GetProperties(ObjectPropertyList list)
		{
			base.GetProperties(list);
			
			list.Add( "<basefont color=#33FF66>Paralyzing ability<basefont color=White>" );
		}

		public override void OnDoubleClick( Mobile from )
		{
			if ( !IsChildOf( from.Backpack ) )
				from.SendLocalizedMessage( 1060640 );
			else if( !from.HasTrade )
			{
				if( this.ItemID == 7035 ) this.ItemID = 7026;
				else if( this.ItemID == 7026 ) this.ItemID = 7027;
				else if( this.ItemID == 7027 ) this.ItemID = 7028;
				else if( this.ItemID == 7028 ) this.ItemID = 7030;
				else if( this.ItemID == 7030 ) this.ItemID = 7032;
				else if( this.ItemID == 7032 ) this.ItemID = 7034;
				else if( this.ItemID == 7034 ) this.ItemID = 0x1BC4;
				else if( this.ItemID == 0x1BC4 ) this.ItemID = 0x1BC3;
				else if( this.ItemID == 0x1BC3 ) this.ItemID = 7035;
				Weight = 6.0;
			}
		}

		public Stit( Serial serial ) : base(serial)
		{
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int)0 );//version
		}
	}
}
